/* timer module registers
 *
 * Copyright (C) 2007 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licence
 * as published by the Free Software Foundation; either version
 * 2 of the Licence, or (at your option) any later version.
 */

#ifndef _MACH_TIMER_REGS_H
#define _MACH_TIMER_REGS_H

#ifdef __KERNEL__

/* timer prescalar control */
#define	TMPSCNT			0x54003071 /* timer prescaler control */
#define	TMPSCNT_ENABLE		0x80	/* timer prescaler enable */
#define	TMPSCNT_DISABLE		0x00	/* timer prescaler disable */

/* 8 bit timers */
#define	TM0MD			0x54003000 /* timer 0 mode register */
#define	TM0MD_SRC		0x07	/* timer source */
#define	TM0MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM0MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM0MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM0MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM0MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM0MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM0MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM1MD			0x54003001 /* timer 1 mode register */
#define	TM1MD_SRC		0x07	/* timer source */
#define	TM1MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM1MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM1MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM1MD_SRC_TM0CASCADE	0x03	/* - cascade with timer 0 */
#define	TM1MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM1MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM1MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM1MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM2MD			0x54003002 /* timer 2 mode register */
#define	TM2MD_SRC		0x07	/* timer source */
#define	TM2MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM2MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM2MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM2MD_SRC_TM1CASCADE	0x03	/* - cascade with timer 1 */
#define	TM2MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM2MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM2MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM2MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM3MD			0x54003003 /* timer 3 mode register */
#define	TM3MD_SRC		0x07	/* timer source */
#define	TM3MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM3MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM3MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM3MD_SRC_TM2CASCADE	0x03	/* - cascade with timer 2 */
#define	TM3MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM3MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM3MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM3MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM3MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM01MD			0x54003000	/* timer 0:1 mode register */

#define	TM0BR			0x54003010	/* timer 0 base register */
#define	TM1BR			0x54003011	/* timer 1 base register */
#define	TM2BR			0x54003012	/* timer 2 base register */
#define	TM3BR			0x54003013	/* timer 3 base register */
#define	TM01BR			0x54003010	/* timer 0:1 base register */

#define	TM0BC			0x54003020	/* timer 0 binary counter */
#define	TM1BC			0x54003021	/* timer 1 binary counter */
#define	TM2BC			0x54003022	/* timer 2 binary counter */
#define	TM3BC			0x54003023	/* timer 3 binary counter */
#define	TM01BC			0x54003020	/* timer 0:1 binary counter */

#define TM0IRQ			36	/* timer 0 IRQ */
#define TM1IRQ			37	/* timer 1 IRQ */
#define TM2IRQ			38	/* timer 2 IRQ */
#define TM3IRQ			39	/* timer 3 IRQ */

/* 16-bit timers 4,5 & 7-15 */
#define	TM4MD			0x54003080   /* timer 4 mode register */
#define	TM4MD_SRC		0x07	/* timer source */
#define	TM4MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM4MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM4MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM4MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM4MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM4MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM4MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM4MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM5MD			0x54003082   /* timer 5 mode register */
#define	TM5MD_SRC		0x07	/* timer source */
#define	TM5MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM5MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM5MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM5MD_SRC_TM4CASCADE	0x03	/* - cascade with timer 4 */
#define	TM5MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM5MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM5MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM5MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM5MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM5MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM7MD			0x54003086   /* timer 7 mode register */
#define	TM7MD_SRC		0x07	/* timer source */
#define	TM7MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM7MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM7MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM7MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM7MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM7MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM7MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM7MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM8MD			0x54003088   /* timer 8 mode register */
#define	TM8MD_SRC		0x07	/* timer source */
#define	TM8MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM8MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM8MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM8MD_SRC_TM7CASCADE	0x03	/* - cascade with timer 7 */
#define	TM8MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM8MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM8MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM8MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM8MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM8MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM9MD			0x5400308a   /* timer 9 mode register */
#define	TM9MD_SRC		0x07	/* timer source */
#define	TM9MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM9MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM9MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM9MD_SRC_TM8CASCADE	0x03	/* - cascade with timer 8 */
#define	TM9MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM9MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM9MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM9MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM9MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM9MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM10MD			0x5400308c   /* timer 10 mode register */
#define	TM10MD_SRC		0x07	/* timer source */
#define	TM10MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM10MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM10MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM10MD_SRC_TM9CASCADE	0x03	/* - cascade with timer 9 */
#define	TM10MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM10MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM10MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM10MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM10MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM10MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM11MD			0x5400308e   /* timer 11 mode register */
#define	TM11MD_SRC		0x07	/* timer source */
#define	TM11MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM11MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM11MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM11MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM11MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM11MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM11MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM11MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM11MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM12MD			0x54003180   /* timer 12 mode register */
#define	TM12MD_SRC		0x07	/* timer source */
#define	TM12MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM12MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM12MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM12MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM12MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM12MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM12MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM12MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM12MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM13MD			0x54003182   /* timer 13 mode register */
#define	TM13MD_SRC		0x07	/* timer source */
#define	TM13MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM13MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM13MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM13MD_SRC_TM12CASCADE	0x03	/* - cascade with timer 12 */
#define	TM13MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM13MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM13MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM13MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM13MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM13MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM14MD			0x54003184   /* timer 14 mode register */
#define	TM14MD_SRC		0x07	/* timer source */
#define	TM14MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM14MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM14MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM14MD_SRC_TM13CASCADE	0x03	/* - cascade with timer 13 */
#define	TM14MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM14MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM14MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM14MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM14MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM14MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM15MD			0x54003186   /* timer 15 mode register */
#define	TM15MD_SRC		0x07	/* timer source */
#define	TM15MD_SRC_IOCLK	0x00	/* - IOCLK */
#define	TM15MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM15MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM15MD_SRC_TM14CASCADE	0x03	/* - cascade with timer 14 */
#define	TM15MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM15MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM15MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM15MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM15MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM15MD_COUNT_ENABLE	0x80	/* timer count enable */


#define	TM4BR			0x54003090	/* timer 4 base register */
#define	TM5BR			0x54003092	/* timer 5 base register */
#define	TM45BR			0x54003090	/* timer 4:5 base register */
#define	TM7BR			0x54003096	/* timer 7 base register */
#define	TM8BR			0x54003098	/* timer 8 base register */
#define	TM9BR			0x5400309a	/* timer 9 base register */
#define	TM89BR			0x54003098	/* timer 8:9 base register */
#define	TM10BR			0x5400309c	/* timer 10 base register */
#define	TM11BR			0x5400309e	/* timer 11 base register */
#define	TM12BR			0x54003190	/* timer 12 base register */
#define	TM13BR			0x54003192	/* timer 13 base register */
#define	TM14BR			0x54003194	/* timer 14 base register */
#define	TM15BR			0x54003196	/* timer 15 base register */

#define	TM4BC			0x540030a0	/* timer 4 binary counter */
#define	TM5BC			0x540030a2	/* timer 5 binary counter */
#define	TM45BC			0x540030a0	/* timer 4:5 binary counter */
#define	TM7BC			0x540030a6	/* timer 7 binary counter */
#define	TM8BC			0x540030a8	/* timer 8 binary counter */
#define	TM9BC			0x540030aa	/* timer 9 binary counter */
#define	TM89BC			0x540030a8	/* timer 8:9 binary counter */
#define	TM10BC			0x540030ac	/* timer 10 binary counter */
#define	TM11BC			0x540030ae	/* timer 11 binary counter */
#define	TM12BC			0x540031a0	/* timer 12 binary counter */
#define	TM13BC			0x540031a2	/* timer 13 binary counter */
#define	TM14BC			0x540031a4	/* timer 14 binary counter */
#define	TM15BC			0x540031a6	/* timer 15 binary counter */

#define TM4IRQ			40	/* timer 4 IRQ */
#define TM5IRQ			41	/* timer 5 IRQ */
#define TM7IRQ			45	/* timer 7 IRQ */
#define TM8IRQ			46	/* timer 8 IRQ */
#define TM9IRQ			47	/* timer 9 IRQ */
#define TM10IRQ			48	/* timer 10 IRQ */
#define TM11IRQ			49	/* timer 11 IRQ */
#define TM12IRQ			50	/* timer 12 IRQ */
#define TM13IRQ			51	/* timer 13 IRQ */
#define TM14IRQ			52	/* timer 14 IRQ */
#define TM15IRQ			53	/* timer 15 IRQ */

/* 16-bit timer 6 */
#define	TM6MD			0x54003084	/* timer6 mode register */
#define	TM6MD_SRC		0x0007	/* timer source */
#define	TM6MD_SRC_IOCLK		0x0000	/* - IOCLK */
#define	TM6MD_SRC_IOCLK_8	0x0001	/* - 1/8 IOCLK */
#define	TM6MD_SRC_IOCLK_32	0x0002	/* - 1/32 IOCLK */
#define	TM6MD_SRC_TM0UFLOW	0x0004	/* - timer 0 underflow */
#define	TM6MD_SRC_TM1UFLOW	0x0005	/* - timer 1 underflow */
#define	TM6MD_SRC_TM2UFLOW	0x0006	/* - timer 2 underflow */
#define	TM6MD_ONESHOT_ENABLE	0x0040	/* oneshot count */
#define	TM6MD_CLR_ENABLE	0x0010	/* clear count enable */

#define	TM6MD_INIT_COUNTER	0x4000	/* initialize TMnBC to zero */
#define	TM6MD_COUNT_ENABLE	0x8000	/* timer count enable */

#define	TM6MDA			0x540030b4	/* timer6 cmp/cap A mode reg */
#define	TM6MDA_MODE_CMP_SINGLE	0x00	/* - compare, single buffer mode */
#define	TM6MDA_MODE_CMP_DOUBLE	0x40	/* - compare, double buffer mode */
#define	TM6MDA_MODE		0x40	/* compare A register mode */

#define	TM6MDB			0x540030b5	/* timer6 cmp/cap B mode reg */
#define	TM6MDB_MODE_CMP_SINGLE	0x00	/* - compare, single buffer mode */
#define	TM6MDB_MODE_CMP_DOUBLE	0x40	/* - compare, double buffer mode */
#define	TM6MDB_MODE		0x40	/* compare B register mode */

#define	TM6CA			0x540030c4	/* timer6 cmp/capture reg A */
#define	TM6CB			0x540030d4	/* timer6 cmp/capture reg B */
#define	TM6BC			0x540030a4	/* timer6 binary counter */

#define TM6IRQ			42	/* timer 6 IRQ */
#define TM6AIRQ			43	/* timer 6A IRQ */
#define TM6BIRQ			44	/* timer 6B IRQ */

#endif /* __KERNEL__ */

#endif /* _MACH_TIMER_REGS_H */
